#pragma once

#include "ServiceSPC.h"
#include "ConfigSPC.h"
#include "IncomingSpeechCall.h"

////////////////////////////////////////////////////////////////////////////////

#define kRingInterval					2500
#define kATRingCommand					"RING"
#define kATCRingCommand					"+CRING: VOICE"
#define kATCallerIdCommand				"+CLIP: "

class CServiceSPC;
class CIncomingSpeechCall;
////////////////////////////////////////////////////////////////////////////////
class CRingThread : public CWinThread
{
	DECLARE_DYNCREATE(CRingThread)

public:
	CRingThread();           // protected constructor used by dynamic creation
	virtual ~CRingThread();	
private:
	CCmd*			mCmd; // fake cmd used to set the channel id used by the formatter
	CServiceSPC*	mServiceSPC;	
	CConfigSPC*		mConfigSPC;	
	CIncomingSpeechCall* mSpeechCall;
	CString			mPhoneNum;
	CCharSetString	mPhoneName;
	Bool			mClipActive;
	Bool			mExtendedFmt;
	Bool			mSendForwardedCall;
	CString			mRc;
	CString			mBuf;
public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
    virtual void Ring(WPARAM iWp, LPARAM iLp);
	virtual void SetServiceSPC(CServiceSPC* iSvcSPC);	
	virtual void SetConfigSPC(CConfigSPC* iCfgSPC);	
	virtual void SetSpeechCall(CIncomingSpeechCall* iISC);

	void SetNumber(CString iNum);
	void SetName(CString iName);
	void SetClip(Bool iClip){mClipActive = iClip;}
	void SetExtendedFmt(Bool iExtendedFmt){mExtendedFmt = iExtendedFmt;}
	void SetSendForwCall(Bool iSendForwardedCall){mSendForwardedCall = iSendForwardedCall;}
protected:
	DECLARE_MESSAGE_MAP()
};


